import { IAnimatorConfiguration } from './IConfig';
import { PropertyAnimator } from '../PropertyAnimator';

export class ScaleConfig implements IAnimatorConfiguration {
    configure(animator: PropertyAnimator, st: ScreenTransform) {
        animator.setupAnimation(() => st.scale,
            (value) => {
                st.scale = value as vec3;
            },
            vec3.lerp);
    }
}
